 ; Ŀ
 ;   L33t - Translate text into Leet.                                      
 ;   Copyright 2004, 2005 by Rocket Software Ltd.                          
 ;   Rename a block to @.  Now rename it back.                             
 ; 

 ; Ŀ
 ;   Subroutine 73g - Rit attribute prompts in the block tables.           
 ;   Takes no arguments.                                                   
 ;   Returns nothing.                                                      
 ;   Calls ph3x.                                                           
 ; 
 (DEFUN 73G (/ reww blokdat first blnam)
  (setq reww T)
  (while (setq blokdat (tblnext "block" reww))
         (setq reww ())
         (setq first (substr (setq blnam (cdr (assoc 2 blokdat))) 1 1))
         (grtext -2 blnam)
         (if (/= first "*")
             (ph3x (cdr (assoc -2 blokdat)))))
 (princ))
 ; Ŀ
 ;   Subroutine 73g end.                                                   
 ; 

 ; Ŀ
 ;   Btx - modify text strings in the block definitions.                   
 ;   Takes no arguments, Returns nothing, leaves a trail of destruction.   
 ;   Calls Rit.                                                            
 ; 
 (DEFUN BTX (/ rew blok namm entt asoc1 str)
  (setq rew t)
  (while (setq blok (tblnext "block" rew))
         (setq rew ())
         (setq namm (cdr (assoc -2 blok)))           ; first ename after head
         (while namm
               (setq entt (entget namm))
               (if (= (cdr (assoc 0 entt)) "TEXT")
                   (progn
                        (setq str (rit (cdr (setq asoc1 (assoc 1 entt)))))
                        (entmod (setq entt (subst (cons 1 str) asoc1 entt)))))
               (setq namm (entnext namm))))
 (princ))
 ; Ŀ
 ;   Subroutine Btx end.                                                   
 ; 

 ; Ŀ
 ;   ph3x - Rit a prompt string in the block tables.                       
 ;   Takes one argument - the first subentity ename.                       
 ;   Calls Rit, Returns nothing.  Called by 73g.                           
 ; 
 (DEFUN PH3X (namm / entt prom1 nup)
  (while (and namm (setq entt (entget namm)))            ; the whole thing
         (if (setq prom1 (assoc 3 entt))
             (progn
                  (setq nup (rit (cdr prom1)))
                  (entmod (subst (cons 3 nup) prom1 entt))))
         (setq namm (entnext namm)))                     ; next subentity ename
 (princ))
 ; Ŀ
 ;   ph3x end.                                                             
 ; 

 ; Ŀ
 ;   Rit: 733+ 4 5+r1ng.                                                   
 ; 
 (DEFUN RIT (str / worlst letlst divlst enam malist sub subx gnulis suba
                                                           nustr subb thestr)
 ; Ŀ
 ;   M4k3 a 715+ 0f w0r|> 3qu1v473n+Z.                                     
 ; 
  (setq worlst '(("A" "@")           ("beer" "b34r")     ("cause" "cuz")
                 ("chick" "Ch1xx0r") ("drain" "br4|n")   ("elite" "l33t")
                 ("enter" "3n+3rz")  ("fear" "ph34r")    ("for" "4")
                 ("girl" "ch1xx0r")  ("good" "l33t")     ("great" "Gr8")
                 ("hacker" "haxxor")
                 ("hey" "w00t")      ("i" "3y3")         ("issued" "|sy00|>")
                 ("like" "gr0k")
                 ("my" "m4")         ("own" "0wnz")      ("owned" "0wnZed")
                 ("bldg." "sh4ck")   ("refrig" "b33r phr|dg3")
                 ("sep" "r1p")       ("separator" "r1pp3r")
                 ("skills" "$Ki11z") ("space" "h073")    ("speak" "sp33k")
                 ("the" "t3h")       ("think" "m3+h|nx") ("to" "2")
                 ("use" "j00s")      ("what" "wu+")      ("yes" "j0")
                 ("you" "j00")))
 ; Ŀ
 ;   M4k3 a 715+ 0f 73++3r 3qu1v473n+Z.                                    
 ; 
  (setq letlst '(("A" "4")  ("C" "(")  ("D" "|)")  ("E" "3")  ("F" "ph")
                 ("G" "9")  ("I" "|")  ("J" "?")   ("K" "|<") ("L" "7")
                 ("O" "0")  ("Q" "2")  ("S" "5")   ("T" "+")  ("W" "\\/\\/")
                 ("X" "><") ("Y" "`/")))
 ; Ŀ
 ;   N0+ uz3|) 5|n(3 ][ |>0n+ r3477`/ 7|k3 c0mp0z|+3 73++3r$.              
 ; 
;  (setq letlst '(("A" "4" "@")   ("B" "*" "|3" "8")  ("C" "*" "(")
;                 ("D" "*" "|)")  ("E" "*" "3" "[-")  ("F" "ph")
;                 ("G" "9")       ("H" "*" "|-|")     ("I" "*" "][" "1")
;                 ("J" "*" "?")   ("K" "*" "|<")      ("L" "7" "|_" "|" "1")
;                 ("M" "|\/|" "^^" "/\/\")            ("N" "|\|")
;                 ("O" "0" "()")  ("P" "*" "|>")      ("Q" "*" "2")
;                 ("R" "*" "|2")  ("S" "5" "$" "Z")   ("T" "*" "+" "7")
;                 ("U" "*" "(_)") ("V" "\/")          ("W" "\/\/" "|/\|")
;                 ("X" "><")      ("Y" "*" "`/" "j")  ("Z" "*" "7_")))
 ; Ŀ
 ;   5p71+ t3h w0rd ][n+0 a 715+ 0ph subs+r1n9z.                           
 ; 
  (setq divlst '(" " "-"))
  (setq malist (slat divlst str))
 ; Ŀ
 ;   Ph0r 34ch w0rd (bu+ n0t 53p4r4+0r), $33 |ph |+ c4|\| b3 d1r3c+7`/     
 ;   5ubz+i+u+3|> 4 4n0+h3r.  If n0+ +h3n |>0 |+ 0n3 73++3r 4+ D4 +|m3.    
 ; 
  (while (setq sub (car malist))
         (setq malist (cdr malist))
 ; Ŀ
 ;   C0nd: t3h 5ubz+Rin9 wuz @ 53p4r4+0r.                                  
 ; 
         (cond ((member (substr sub 1 1) divlst)
                (setq gnulis (append gnulis (list sub))))
 ; Ŀ
 ;   C0nd: t3h 5ubz+r|n9 wuz |n d4 w0r|> 715+.                             
 ; 
               ((setq suba (member sub worlst))
                (setq sub (caar suba))
                (setq gnulis (append gnulis (list sub))))
 ; Ŀ
 ;   C0nd: t3h 5ubz+r1ng wuz |n d4 w0r|> 715+ w|+h an 3n|>1n9 S.           
 ; 
               ((and (setq subx (substr sub 1 (1- (strlen sub))))
                     (setq suba (member subx worlst)))
                (setq sub (caar suba))
                (setq sub (strcat sub "Z"))
                (setq gnulis (append gnulis (list sub))))
 ; Ŀ
 ;   C0nd: t3h |>3ph4u7+: 5709 |+ 0u+ 0n3 73++3r @ @ +|m3.                 
 ; 
               (T
                (setq sub (strcase sub))
 ; Ŀ
 ;   |ph 4 w0rd b3g|nZ w|+h "s" j00z "f".                                  
 ; 
                (if (= (setq suba (substr sub 1 1)) "S")
                    (setq nustr "f")
                    (if (setq subb (cadr (assoc suba letlst)))
                        (setq nustr subb)
                        (setq nustr suba)))
                (setq sub (substr sub 2))
 ; Ŀ
 ;   +r4n574+3 t3h r35+ 0ph t3h 5+r|n9.                                    
 ; 
                (while (/= "" (setq suba (substr sub 1 1)))
                       (setq sub (substr sub 2))
                       (if (setq subb (cadr (assoc suba letlst)))
                           (setq nustr (strcat nustr subb))
                           (setq nustr (strcat nustr suba))))
                (setq gnulis (append gnulis (list nustr))))))
 ; Ŀ
 ;   R34$$3mb73 t3h s+r1n9.                                                
 ; 
  (setq thestr "")
  (mapcar '(lambda (astr)
            (setq thestr (strcat thestr astr)))
            gnulis)
  thestr)
 ; Ŀ
 ;   Rit 3n|>.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Slat - divide up a text string into a list, keep spaces.   
 ;   Arguments: Seplst, the separator character list.                      
 ;              Linn, the text string.                                     
 ;   Calls nothing.                                                        
 ;   Returns a list of field and separator values.                         
 ;                                                                         
 ;   Written 2005.03.29.                                                   
 ; 
 (DEFUN SLAT (seplst linn / chra sepa custar presep malist)
  (while (/= (setq chra (substr linn 1 1)) "")
         (setq linn (substr linn 2))
         (if (member chra seplst)
             (setq sepa "s")
             (setq sepa "b"))
 ; Ŀ
 ;   See if the character is a separator or a body character.              
 ;   If it is the same as the previous one, add it to the current string.  
 ;   If not add the old string to the master list and start a new one.     
 ;   If there is no string (and thus no previous character type) start     
 ;   one with that character.                                              
 ; 
         (cond ((null presep)
                (setq custar chra)
                (setq presep sepa))
               ((= sepa presep)
                (setq custar (strcat custar chra)))
               (t
                (setq malist (append malist (list custar)))
                (setq custar chra)
                (setq presep sepa))))
 ; Ŀ
 ;   Add any leftover string to malist, return malist.                     
 ; 
  (if custar (setq malist (append malist (list custar))))
 malist)
 ; Ŀ
 ;   Slat end.                                                             
 ; 

 ; Ŀ
 ;   L33T.                                                                 
 ; 
 (DEFUN C:L33T (/ rad ss num enam txt entt pa esub)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (setq rad (/ (getvar "viewsize") 45))
  (setq ss (ssget "x" '((-4 . "<or") (0 . "text") (0 . "mtext") (-4 . "or>"))))
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq txt (cdr (assoc 1 (setq entt (entget enam)))))
         (setq txt (rit txt))
         (setq pa (cdr (assoc 10 entt)))
         (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 1)
         (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 1)
         (princ)
         (entmod (subst (cons 1 txt) (assoc 1 entt) entt)))
  (setq num 0)
  (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
  (while (and ss (setq enam (ssname ss num)))
         (setq esub (entnext enam))
         (setq num (1+ num))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                (setq txt (cdr (assoc 1 entt)))
                (setq txt (rit txt))
                (setq pa (cdr (assoc 10 entt)))
                (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) 7)
                (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) 7)
                (princ)
                (entmod (subst (cons 1 txt) (assoc 1 entt) entt))
                (setq esub (entnext esub)))
         (entupd enam))
  (73g)
  (btx)
  (command ".regenall")
  (command "undo" "end")
 (princ))